unit WSockUtils;

interface
uses
  WinSock;


// T[o[IPAhX擾
function GetIpAddressStr(server: string): string;


var
  WSAData: TWSAData;

implementation


// T[o[IPAhX擾
function GetIpAddressStr(server: string): string;
var
  addr: u_long;
  phe: PHostEnt;
begin
  // T[o[IPAhX𓾂
  phe := gethostbyname(PChar(server));
  if phe = nil then
  begin
    // IPAhX̎w肪H
    addr := inet_addr(PChar(server));
    phe  := gethostbyaddr(@addr, 4, AF_INET);
  end;
  if phe = nil then
  begin
    Result := ''; // s
  end else
  begin
    // in_addr^Axxx.xxx.xxx.xxx ̕ɕϊ
    Result := inet_ntoa(PInAddr(phe.h_addr_list^)^);
  end;
end;

initialization
  WSAStartup($0101, WSAData); // WinSock 

finalization
  WSACleanup; // WinSock I

end.
