unit frmTestU;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, WSockUtils;

type
  TfrmTest = class(TForm)
    Label1: TLabel;
    edtFind: TEdit;
    btnFind: TButton;
    memo: TMemo;
    edtSend: TEdit;
    btnSend: TButton;
    Label2: TLabel;
    edtPort: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure btnFindClick(Sender: TObject);
    procedure btnSendClick(Sender: TObject);
    procedure edtSendKeyPress(Sender: TObject; var Key: Char);
  private
    { Private 錾 }
    client : TKTcpClient;
    procedure hostOnRecv(Sender: TObject);
    procedure hostOnSend(Sender: TObject);
    procedure hostOnConnect(Sender: TObject);
    procedure hostOnDisconnect(Sender: TObject);
    procedure hostOnError(Sender: TObject);
    procedure addLog(s: string);
  public
    { Public 錾 }

  end;

var
  frmTest: TfrmTest;

implementation

{$R *.dfm}

procedure TfrmTest.FormCreate(Sender: TObject);
begin
  client := TKTcpClient.Create(Self);
  client.OnConnect := hostOnConnect;
  client.OnDisconnect := hostOnDisconnect;
  client.OnSend := hostOnSend;
  client.OnRecv := hostOnRecv;
  client.OnError := hostOnError;
end;


procedure TfrmTest.hostOnConnect(Sender: TObject);
begin
  addLog('ڑ');
end;

procedure TfrmTest.hostOnDisconnect(Sender: TObject);
begin
  addLog('ؒf');
end;

procedure TfrmTest.hostOnError(Sender: TObject);
begin
  addLog('G[: '+client.ErrorMsg);
end;

procedure TfrmTest.hostOnRecv(Sender: TObject);
begin
  addLog('M: ' + client.RecvData.DataString);
  client.RecvData.Size := 0; // [
end;

procedure TfrmTest.hostOnSend(Sender: TObject);
begin
  addLog('M');
end;

procedure TfrmTest.btnFindClick(Sender: TObject);
begin
  if client.Connected then
  begin
    client.Close;
    Exit;
  end;
  client.Host := edtFind.Text;
  client.Port := edtPort.Text;
  client.Open;
end;

procedure TfrmTest.btnSendClick(Sender: TObject);
begin
  client.Send(edtSend.Text+#13#10);
  edtSend.Text := '';
end;

procedure TfrmTest.edtSendKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then btnSendClick(nil);
end;

procedure TfrmTest.addLog(s: string);
begin
  memo.Lines.Add(s);
  memo.SelStart := Length(memo.Text) ;
end;

end.
