unit WSockUtils;

interface
uses
  SysUtils, Classes, Windows, Messages, WinSock;

type
  // obt@t THostEnt (WSAAsyncGetHostByName ŕKv)
  TGetHostEnt = record
    case Byte of
      0: (buf     : array [0..MAXGETHOSTSTRUCT-1] of Char);
      1: (hostent : THostEnt);
  end;

  // 񓯊zXg擾NX
  TFindHostInfo = class(TComponent)
  private
    FHost: string;
    FWindow: HWND;
    FTask: THandle;
    FHostEnt: TGetHostEnt;
    FErrorCode: Integer;
    FOnFind: TNotifyEvent;
    FOnError: TNotifyEvent;
    procedure WndProc(var Msg: TMessage);
    procedure RecvASyncMsg(var Msg: TMessage);
    function getPHostEnt: PHostEnt;
    function getIpFromHostEnt: TInAddr;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Find(Host: string);
    procedure Cancel;
    property Host: string read FHost;            // OnFindœ錋
    property IP: TInAddr read getIpFromHostEnt;  // OnFindœ錋
    property HostEnt: PHostEnt read getPHostEnt; // OnFindœ錋
    property ErrorCode: Integer read FErrorCode; // OnErrorœ錋
    property OnFind : TNotifyEvent read FOnFind write FOnFind;  // ʒm
    property OnError: TNotifyEvent read FOnError write FOnError;// G[ʒm
  end;

  // 񓯊TCPNCAg
  EKTcpClient = class(Exception);
  TKTcpClient = class(TComponent)
  private
    FWindow: HWND;
    FSocket: Integer;
    FRecvData: TStringStream; // Mf[^𒙂߂Ă
    FFindFostInfo: TFindHostInfo;
    FHost: string;
    FPort: string;
    FErrorCode: Integer;
    FErrorMsg: string;
    FConnected: Boolean;
    FOnConnect: TNotifyEvent;
    FOnDisconnect: TNotifyEvent;
    FOnSend: TNotifyEvent;
    FOnRecv: TNotifyEvent;
    FOnError: TNotifyEvent;
    procedure WndProc(var Msg: TMessage);
    procedure HostOnFind(Sender: TObject);
    procedure HostOnError(Sender: TObject);
    procedure DoConnect(ip: TInAddr);
    procedure DoDisconnect;
    procedure DoRecv;
    procedure DoWrite;
    function ErrorCheck(v: Integer; msg: string): Integer; virtual;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Open; virtual;
    procedure Close; virtual;
    procedure Send(s: string);
    property Host: string read FHost write FHost;
    property Port: string read FPort write FPort;
    property ErrorCode: Integer read FErrorCode;
    property ErrorMsg: string read FErrorMsg;
    property RecvData: TStringStream read FRecvData;
    property Connected: Boolean read FConnected;
    property OnConnect: TNotifyEvent read FOnConnect write FOnConnect;
    property OnDisconnect: TNotifyEvent read FOnDisconnect write FOnDisconnect;
    property OnSend: TNotifyEvent read FOnSend write FOnSend;    // Mʒm
    property OnRecv: TNotifyEvent read FOnRecv write FOnRecv;    // Mʒm
    property OnError: TNotifyEvent read FOnError write FOnError; // G[ʒm
  end;

const
  WM_WINSOCK_ASYNC_MSG_STR = 'com.nadesi.async.winsock';

var
  WSAData: TWSAData;
  WM_WINSOCK_ASYNC_MSG: Cardinal = 0;

function GetSockErrorMsg(err: Integer): string;

implementation

function GetSockErrorMsg(err: Integer): string;
begin
  case err of
    WSABASEERR:          Result := '[0] No Error';
    WSAEINTR:            Result := '[10004] Interrupted system call';
    WSAEBADF:            Result := '[10009] Bad file number';
    WSAEACCES:           Result := '[10013] Permission denied';
    WSAEFAULT:           Result := '[10014] Bad address';
    WSAEINVAL:           Result := '[10022] Invalid argument';
    WSAEMFILE:           Result := '[10024] Too many open files';
    WSAEWOULDBLOCK:      Result := '[10035] Operation would block';
    WSAEINPROGRESS:      Result := '[10036] Operation now in progress';
    WSAEALREADY:         Result := '[10037] Operation already in progress';
    WSAENOTSOCK:         Result := '[10038] Socket operation on non-socket';
    WSAEDESTADDRREQ:     Result := '[10039] Destination address required';
    WSAEMSGSIZE:         Result := '[10040] Message too long';
    WSAEPROTOTYPE:       Result := '[10041] Protocol wrong type for socket';
    WSAENOPROTOOPT:      Result := '[10042] Bad protocol option';
    WSAEPROTONOSUPPORT:  Result := '[10043] Protocol not supported';
    WSAESOCKTNOSUPPORT:  Result := '[10044] Socket type not supported';
    WSAEOPNOTSUPP:       Result := '[10045] Operation not supported on socket';
    WSAEPFNOSUPPORT:     Result := '[10046] Protocol family not supported';
    WSAEAFNOSUPPORT:     Result := '[10047] Address family not supported by protocol family';
    WSAEADDRINUSE:       Result := '[10048] Address already in use';
    WSAEADDRNOTAVAIL:    Result := '[10049] Can''t assign requested address';
    WSAENETDOWN:         Result := '[10050] Network is down';
    WSAENETUNREACH:      Result := '[10051] Network is unreachable';
    WSAENETRESET:        Result := '[10052] Net dropped connection or reset';
    WSAECONNABORTED:     Result := '[10053] Software caused connection abort';
    WSAECONNRESET:       Result := '[10054] Connection reset by peer';
    WSAENOBUFS:          Result := '[10055] No buffer space available';
    WSAEISCONN:          Result := '[10056] Socket is already connected';
    WSAENOTCONN:         Result := '[10057] Socket is not connected';
    WSAESHUTDOWN:        Result := '[10058] Can''t send after socket shutdown';
    WSAETOOMANYREFS:     Result := '[10059] Too many referencescan''t splice';
    WSAETIMEDOUT:        Result := '[10060] Connection timed out';
    WSAECONNREFUSED:     Result := '[10061] Connection refused';
    WSAELOOP:            Result := '[10062] Too many levels of symbolic links';
    WSAENAMETOOLONG:     Result := '[10063] File name too long';
    WSAEHOSTDOWN:        Result := '[10064] Host is down';
    WSAEHOSTUNREACH:     Result := '[10065] No Route to Host';
    WSAENOTEMPTY:        Result := '[10066] Directory not empty';
    WSAEPROCLIM:         Result := '[10067] Too many processes';
    WSAEUSERS:           Result := '[10068] Too many users';
    WSAEDQUOT:           Result := '[10069] Disc Quota Exceeded';
    WSAESTALE:           Result := '[10070] Stale NFS file handle';
    WSAEREMOTE:          Result := '[10071] Too many levels of remote in path';
    WSASYSNOTREADY:      Result := '[10091] Network SubSystem is unavailable';
    WSAVERNOTSUPPORTED:  Result := '[10092] WINSOCK DLL Version out of range';
    WSANOTINITIALISED:   Result := '[10093] Successful WSASTARTUP not yet performed';
    WSAHOST_NOT_FOUND:   Result := '[11001] Host not found';
    WSATRY_AGAIN:        Result := '[11002] Non-Authoritative Host not found';
    WSANO_RECOVERY:      Result := '[11003] Non-Recoverable errors: FORMER RREFUSED NOTIMP';
    WSANO_DATA:          Result := '[11004] Valid name no data record of requested type';
    else                 Result := '[' + IntToStr(err) + '] G[';
  end;
end;

{ TFindHostInfo }

procedure TFindHostInfo.Cancel;
begin
  if FTask = 0 then Exit;
  WSACancelAsyncRequest(FTask);
  FTask := 0;
end;

constructor TFindHostInfo.Create(AOwner: TComponent);
begin
  inherited;
  FWindow := Classes.AllocateHWnd(WndProc);
  FTask := 0;
  FErrorCode := 0;
  ZeroMemory(@FHostEnt, sizeof(FHostEnt));
end;

destructor TFindHostInfo.Destroy;
begin
  Cancel;
  Classes.DeallocateHWnd(FWindow);
  inherited;
end;

procedure TFindHostInfo.Find(Host: string);
var
  ip: u_long;
begin
  Cancel; // ȂxLZ

  FHost := Host;
  FOnFind := OnFind;

  ip := inet_addr(PChar(Host));
  if ip = INADDR_NONE then
  begin
    // zXgŌ
    FTask := WSAAsyncGetHostByName(FWindow, WM_WINSOCK_ASYNC_MSG, PChar(FHost),
      @FHostEnt, sizeof(FHostEnt));
  end else
  begin
    // IPAhXŌ
    FTask := WSAAsyncGetHostByAddr(FWindow, WM_WINSOCK_ASYNC_MSG, @ip,
      sizeof(ip), AF_INET, @FHostEnt, sizeof(FHostEnt));
  end;
  if FTask = 0 then
  begin
    FErrorCode := WSAGetLastError;
    if Assigned(FOnError) then FOnError(Self);
  end;
end;

function TFindHostInfo.getIpFromHostEnt: TInAddr;
begin
  Result := PinAddr(FHostEnt.hostent.h_addr_list^)^;
end;

function TFindHostInfo.getPHostEnt: PHostEnt;
begin
  Result := @FHostEnt;
end;

procedure TFindHostInfo.RecvASyncMsg(var Msg: TMessage);
begin
  if FTask = 0 then Exit; // ɖ

  // H
  FErrorCode := WSAGetAsyncError(Msg.lParam);
  if FErrorCode <> 0 then // s
  begin
    if Assigned(FOnError) then FOnError(Self);
    Exit;
  end;
  FHost := FHostEnt.hostent.h_name;
  FTask := 0;
  if Assigned(FOnFind) then FOnFind(Self);
end;

procedure TFindHostInfo.WndProc(var Msg: TMessage);
begin
  if Msg.Msg = WM_WINSOCK_ASYNC_MSG then
  begin
    RecvASyncMsg(Msg);
  end else
  begin
    Msg.Result := DefWindowProc(FWindow, Msg.Msg, Msg.WParam, Msg.LParam);
  end;
end;

{ TKTcpClient }

procedure TKTcpClient.Open;
var
  ip: TInAddr;
begin
  if Host = '' then raise EKTcpClient.Create('zXgݒ肳Ă܂B');
  if Port = '' then raise EKTcpClient.Create('|[gԍݒ肳Ă܂B');
  if StrToIntDef(Port, -1) < 0 then raise EKTcpClient.Create('|[gԍsłB');

  if FConnected then Close;
  FErrorMsg  := '';
  FErrorCode := 0;

  // \Pbg̍쐬
  if FSocket = INVALID_SOCKET then
  begin
    FSocket := socket(AF_INET, SOCK_STREAM, 0);
    if FSocket = INVALID_SOCKET then
    begin
      FErrorMsg  := '\Pbg̍쐬Ɏs';
      FErrorCode := WSAGetLastError;
      raise EKTcpClient.Create(FErrorMsg + '#' + IntToStr(FErrorCode));
    end;
  end;

  // CxgMp̃nh̊蓖
  if FWindow = INVALID_HANDLE_VALUE then
  begin
    FWindow := Classes.AllocateHWnd(WndProc);
  end;

  // IPAhXw肩H
  ip.S_addr := inet_addr(PChar(Host));
  if ip.S_addr <> INADDR_NONE then
  begin
    // IPAhXwȂzXǧ͕sv
    DoConnect(ip); Exit;
  end else
  begin
    // zXgw
    FFindFostInfo.Find(Host);
    // HostOnFind Ă΂邱Ƃ
    // HostOnFind  DoConnect Ă΂
  end;
end;

constructor TKTcpClient.Create(AOwner: TComponent);
begin
  inherited;
  // sEBhE(CxgMp)
  FWindow := INVALID_HANDLE_VALUE;
  FSocket := INVALID_SOCKET;

  // zXgp
  FFindFostInfo := TFindHostInfo.Create(Self);
  with FFindFostInfo do begin
    OnFind  := HostOnFind;
    OnError := HostOnError;
  end;

  // Mf[^obt@
  FRecvData := TStringStream.Create('');
  FConnected := False;
end;

destructor TKTcpClient.Destroy;
begin
  FreeAndNil(FRecvData);
  FreeAndNil(FFindFostInfo);

  Classes.DeallocateHWnd(FWindow);
  closesocket(FSocket);
  inherited;
end;

procedure TKTcpClient.Close;
begin
  if FConnected then
  begin
    ErrorCheck(shutdown(FSocket, 1), 'Vbg_EɎs܂B');
    // SĂ̒ʒmItɁB
    WSAAsyncSelect(FSocket, FWindow, 0, 0);
    DoRecv;
  end;
  DoDisconnect;
end;

procedure TKTcpClient.DoConnect(ip: TInAddr);
var
  addr: TSockAddr;
  ret: Integer;
begin
  // ڑZbg
  ZeroMemory(@addr, sizeof(addr));
  addr.sin_family := AF_INET;
  addr.sin_port   := htons(StrToIntDef(Port, 80));
  addr.sin_addr   := ip;

  // ڑݒ
  ret := ErrorCheck(WSAAsyncSelect(FSocket, FWindow, WM_WINSOCK_ASYNC_MSG,
        FD_CONNECT or FD_WRITE or FD_READ or FD_CLOSE),
        'ڑݒɎs܂B');
  if ret = SOCKET_ERROR then Exit;

  // ڑ
  if WinSock.connect(FSocket, addr, sizeof(addr)) = SOCKET_ERROR then
  begin
    if WSAGetLastError <> WSAEWOULDBLOCK then
    begin
      FErrorCode := WSAGetLastError;
      FErrorMsg  := Host + 'ւ̐ڑɎs܂B' + GetSockErrorMsg(FErrorCode);
      if Assigned(FOnError) then FOnError(Self);
    end;
  end else
  begin
		PostMessage(FWindow ,WM_WINSOCK_ASYNC_MSG, FSocket,
      WSAMAKESELECTREPLY(FD_CONNECT,0));
  end;
end;

procedure TKTcpClient.HostOnError(Sender: TObject);
begin
  FErrorMsg  := Host + '܂B';
  FErrorCode := FFindFostInfo.ErrorCode;

  if Assigned(FOnError) then FOnError(Self);
end;

procedure TKTcpClient.HostOnFind(Sender: TObject);
begin
  DoConnect(FFindFostInfo.IP);
end;

procedure TKTcpClient.WndProc(var Msg: TMessage);
begin
  // ̑̃bZ[W
  if Msg.Msg <> WM_WINSOCK_ASYNC_MSG then
  begin
    Msg.Result := DefWindowProc(FWindow, Msg.Msg, Msg.WParam, Msg.LParam);
    Exit;
  end;

  // \Pbg̃bZ[W
  if Msg.WParam <> FSocket then Exit;

  // MG[
  FErrorCode := WSAGetSelectError(Msg.lParam);
	if FErrorCode <> 0 then
  begin
    if FErrorCode <> WSAEWOULDBLOCK then
    begin
      FErrorMsg := GetSockErrorMsg(FErrorCode);
      if Assigned(FOnError) then FOnError(Self);
    end;
		Exit;
	end;

  // M
  case WSAGetSelectEvent(Msg.lParam) of
    FD_CONNECT  :
      begin
        FConnected := True;
        if Assigned(FOnConnect) then FOnConnect(Self);
      end;
    FD_READ     : DoRecv;
    FD_WRITE    : DoWrite;
    FD_CLOSE    : DoDisconnect;
  end;
end;

function TKTcpClient.ErrorCheck(v: Integer; msg: string): Integer;
begin
  if v = SOCKET_ERROR then
  begin
    FErrorCode := WSAGetLastError;
    FErrorMsg  := msg + '#' + GetSockErrorMsg(FErrorCode);
    if Assigned(FOnError) then FOnError(Self);
  end;
  Result := v;
end;

procedure TKTcpClient.Send(s: string);
begin
  if s = '' then Exit;
  ErrorCheck(
    WinSock.send(FSocket, s[1], Length(s), 0),
    'MɎs܂B'
  );
end;

procedure TKTcpClient.DoRecv;
var
  cnt, totalLen: Integer;
  buf: Array [1..1028 * 8] of Char;
begin
  totalLen := 0;
  while True do
  begin
    // M
    cnt := recv(FSocket, buf[1], Length(buf), 0);
    if cnt = 0 then Break; // MI

    // G[̎
    if cnt = SOCKET_ERROR then
    begin
      if WSAGetLastError <> WSAEWOULDBLOCK then
      begin
        ErrorCheck(cnt, 'MɎs܂B'); Exit;
      end;
      Break;
    end;

    // Mf[^ɒǉ
    FRecvData.Write(buf[1], cnt);
    Inc(totalLen, cnt);
    if cnt < Length(buf) then Break;
  end;
  // ۂɎMf[^Βʒm
  if totalLen > 0 then
  begin
    if Assigned(FOnRecv) then FOnRecv(Self);
  end;
end;

procedure TKTcpClient.DoWrite;
begin
  if Assigned(FOnSend) then FOnSend(Self);
end;

procedure TKTcpClient.DoDisconnect;
begin
  // EBhEj
  if FWindow <> INVALID_HANDLE_VALUE then Classes.DeallocateHWnd(FWindow);
  FWindow := INVALID_HANDLE_VALUE;

  // \Pbg
  if FSocket <> INVALID_SOCKET then closesocket(FSocket);
  FSocket := INVALID_SOCKET;

  FConnected := False;
  if Assigned(FOnDisconnect) then FOnDisconnect(Self);
end;

initialization
  // WinSock 
  WSAStartup($0101, WSAData);

  // IWiWINDOWbZ[W̓o^
  WM_WINSOCK_ASYNC_MSG := RegisterWindowMessage(WM_WINSOCK_ASYNC_MSG_STR);

finalization
  WSACleanup; // WinSock I


end.
